﻿"""
nn5.pyプログラム
5入力のニューラルネットの計算
使い方　>python nn5.py 
"""
# モジュールをインポート
import math # シグモイド関数の計算に必要

# 大域変数の定義
INPUTNO = 5       #入力数
HIDDENNO = 2      #中間層の人工ニューロン数

# 下請け関数の定義
# setdata()関数
def setdata(e):
    # 検査データの設定
    e.append( [0, 1, 1, 1, 1, 1] )
    e.append( [1, 0, 0, 0, 0, 0] )
    e.append( [0, 0, 0, 0, 1, 0] )
    e.append( [0, 1, 1, 0, 0, 0] )
    e.append( [1, 1, 1, 0, 0, 0] )
    e.append( [1, 1, 1, 1, 1, 1] )
    e.append( [0, 1, 1, 0, 0, 0] )
    e.append( [0, 0, 1, 0, 0, 0] )
    e.append( [1, 0, 0, 0, 0, 0] )
    e.append( [0, 1, 0, 0, 0, 0] )
    e.append( [1, 0, 1, 1, 1, 0] )
    e.append( [1, 0, 0, 1, 1, 0] )
    e.append( [1, 1, 1, 0, 0, 0] )
    e.append( [0, 1, 1, 1, 0, 0] )
    e.append( [0, 0, 1, 0, 0, 0] )
    e.append( [1, 0, 1, 1, 0, 0] )
    e.append( [1, 0, 1, 0, 0, 0] )
    e.append( [0, 1, 0, 0, 1, 1] )
    e.append( [1, 0, 0, 1, 1, 0] )
    # データセットの個数の設定
    n = len(e)
    return n 
# setdata()関数の終わり

# nnforward()関数
def nnforward(wh,wo,h,e):
    # 順方向の計算
    # 中間層の出力hの計算
    for i in range(HIDDENNO): # 中間層の各人工ニューロン
        u = 0.0 
        for j in range(INPUTNO):# 積和の値（手順①）
            u += e[j] * wh[i][j]
        u -= wh[i][-1] # しきい値の処理（手順②）
        h[i] = f(u)    # 伝達関数の処理（手順③）
    # 出力oの計算
    o=0.0
    for i in range(HIDDENNO):# 積和の値（手順①）
        o += h[i] * wo[i]
    o -= wo[-1] # しきい値の処理（手順②）
    return f(o) # 伝達関数の処理（手順③）
# nnforward()関数の終わり

# f()関数
def f(u):
    # 伝達関数（シグモイド関数）の計算
    return 1.0 / (1.0 + math.exp(-u)) 
# f()関数の終わり

# メイン実行部
# 変数の初期化
h = [0 for i in range(HIDDENNO + 1)]    # 中間層の出力値

wh = [[-0.019664033044865886, 2.6827187538761326, -0.15257357453235643, 0.22942242311673688, 2.253259534117946, 3.178162825416362], [-0.8013510576775167, -3.916267958674158, 0.9265213407505752, -1.4924934825518092, -3.5992610747209826, -5.626893208782566]] 

wo = [5.730577963830865, -8.549804379338788, -0.3165754264894605]

# 重みの出力
print(wh,wo)

# 検査データの設定
e = []              # 検査データセット
n_of_e = setdata(e) # 検査データセットの設定

# 検査データセットの確認
print(e) 
print("検査データの個数:",n_of_e)

# 検査データに対するネットワークの出力 
for i in range(n_of_e): # 検査データセットすべてについて計算
    print(i,":",e[i],"->", nnforward(wh,wo,h,e[i]))

# nn5.pyの終わり
