﻿"""
nn1.pyプログラム
階層型ニューラルネットの計算プログラム１
伝達関数はステップ関数
使い方　>python nn1.py 
"""
# 大域変数の定義
# 重みとしきい値の設定 
wall =[[-2, 3, -1], [-2, 1, 0.5], [-60, 94, -1]]
INPUTNO = len(wall[0]) - 1  # 入力の個数

# 下請け関数の定義
# forward()関数
def forward(x, w):
    # 計算手順①②　各入力値に重みを掛けて足し合わせ、しきい値を引く
    u = 0 # 計算手順①②の結果
    for i in range(len(w)): # 重みとしきい値の計算
        u += w[i] * x[i] 
    # 伝達関数の適用
    return f(u)
# forward()関数の終わり

# 伝達関数（ステップ関数）f()
def f(u):
    if u >= 0 :
        return 1
    else :
        return 0 
# f()関数の終わり

# メイン実行部
# 入力と計算の繰り返し
while True :  #整数以外が入力されるまで繰り返す
    x = [] # 入力値
    try:
        for _ in range(INPUTNO):
            x.append(float(input("入力(0/1)：")))
    except :     #入力終了
        break
    x.append(-1) # しきい値分の仮入力値
    # 中間層の計算
    h = [] # 中間層の出力値
    for i in range(len(wall) -1):
        h.append(forward(x, wall[i]))
    h.append(-1) # しきい値分の仮入力値
    # 出力層の計算      
    print("計算結果", forward(h, wall[-1])) 
# nn1.pyの終わり
