﻿"""
neuron3.pyプログラム
人工ニューロンの計算プログラム3
3入力の論理和を計算します。
使い方　>python neuron3.py 
"""
# 大域変数の定義
w = [1.0, 1.0, 1.0, 0.5] # 重みとしきい値
INPUTNO = len(w) - 1 # 入力の個数

# 下請け関数の定義
# forward()関数
def forward(x):
    # 計算手順①②　各入力値に重みを掛けて足し合わせ、しきい値を引く
    u = 0 # 計算手順①②の結果
    for i in range(len(w)): # 重みとしきい値の計算
        u += w[i] * x[i] 
    # 伝達関数の適用
    return f(u)
# forward()関数の終わり

# 伝達関数（ステップ関数）f()
def f(u):
    if u >= 0 :
        return 1
    else :
        return 0 
# f()関数の終わり

# メイン実行部
# 入力と計算の繰り返し
while True :  #整数以外が入力されるまで繰り返す
    x = [] # 入力値
    try:
        for _ in range(INPUTNO):
            x.append(float(input("入力(0/1)：")))
    except :     #入力終了
        break
    x.append(-1) # しきい値分の仮入力値

    print("計算結果", forward(x)) 
# neuron3.pyの終わり
