﻿"""
backp.pyプログラム
誤差逆伝播によるニューラルネットの学習  
使い方　>python backp.py 
"""

# モジュールをインポート
import math   # シグモイド関数の計算に必要
import random # パラメタの初期化に必要

# 大域変数の定義
INPUTNO = 2         # 入力数
HIDDENNO = 2        # 中間層の人工ニューロン数
ALPHA = 5           # 学習係数
RSEED = 65535       # 乱数のシード
BIGNUMBER = 100.0   # 誤差の初期値
LIM = 0.001         # 誤差の上限値

# 下請け関数の定義
# setdata()関数
def setdata(e):
    # 学習データの設定
    e.append([0, 0, 0])
    e.append([0, 1, 0])
    e.append([1, 0, 0])
    e.append([1, 1, 1])
    # データセットの個数の設定
    n = len(e)
    return n 
# setdata()関数の終わり

# nnforward()関数
def nnforward(wh,wo,h,e):
    # 順方向の計算
    # 中間層の出力hの計算
    for i in range(HIDDENNO): # 中間層の各人工ニューロン
        u = 0.0 
        for j in range(INPUTNO):# 積和の値（手順①）
            u += e[j] * wh[i][j]
        u -= wh[i][-1] # しきい値の処理（手順②）
        h[i] = f(u)    # 伝達関数の処理（手順③）
    # 出力oの計算
    o=0.0
    for i in range(HIDDENNO):# 積和の値（手順①）
        o += h[i] * wo[i]
    o -= wo[-1] # しきい値の処理（手順②）
    return f(o) # 伝達関数の処理（手順③）
# nnforward()関数の終わり

# f()関数
def f(u):
    # 伝達関数（シグモイド関数）の計算
    return 1.0 / (1.0 + math.exp(-u)) 
# f()関数の終わり

# learn()関数
def learn(wh,wo,h,e,o):
    # 中間層と出力層の学習
    # 出力層の学習
    olearn(wo,h,e,o)
    # 中間層の学習
    hlearn(wh,wo,h,e,o)
    return
# learn()関数の終わり

# olearn()関数
def olearn(wo,h,e,o):
    # 出力層の学習
    # 誤差の計算
    d = (e[INPUTNO] - o) * o * (1 - o)
    # 出力層の重みの学習
    for i in range(HIDDENNO):
        wo[i] += ALPHA * h[i] * d
    # 出力層のしきい値の学習
    wo[-1] += ALPHA * (-1.0) * d
    return 
# olearn()関数の終わり

# hlearn()関数
def hlearn(wh,wo,h,e,o):
    # 中間層の学習
    # 中間層の各人工ニューロンjを対象
    for j in range(HIDDENNO):
        dj = h[j] * (1 - h[j]) * wo[j] * (e[INPUTNO] - o) * o * (1 - o)
        # i番目の重みを処理
        for i in range(INPUTNO):
            wh[j][i] += ALPHA * e[i] * dj
        # しきい値の学習
        wh[j][-1] += ALPHA * (-1.0) * dj
    return 
# hlearn()関数の終わり

# メイン実行部
# 乱数の初期化
random.seed(RSEED)

# 変数の初期化（学習手続き(1)）
# 中間層の重み
wh = [[random.uniform(-1,1) for i in range(INPUTNO + 1)] for j in range(HIDDENNO)]        
# 出力層の重み
wo = [random.uniform(-1,1) for i in range(HIDDENNO + 1)]     
# 中間層の出力値
h = [0 for i in range(HIDDENNO + 1)]    
# 誤差の初期値
error = BIGNUMBER                       

# 重みの初期値（ランダム）の出力
print(wh,wo) 

# 学習データの設定
e = []              # 学習データセット
n_of_e = setdata(e) # 学習データセットの設定

# 学習データセットの確認
print(e)            
print("学習データの個数:", n_of_e)

# 学習の繰り返し（学習手続き(2)）
count = 0 # 繰り返し回数のカウント
while error > LIM : # 誤差の和が上限値LIMを上回る間繰り返す
    error = 0.0
    for j in range(n_of_e):
        # 順方向の計算
        o = nnforward(wh,wo,h,e[j])
        # 各階層の学習
        learn(wh,wo,h,e[j],o)
        # 誤差値の積算
        error += (o - e[j][INPUTNO]) ** 2 
    count += 1
    # 誤差値の出力
    print(count, " ", error)

# 学習結果（重みとしきい値）の出力
print(wh,wo) # Pythonのリストの形式で出力

# 学習データに対するネットワークの出力値 
for i in range(n_of_e): # 学習データセットすべてについて計算
    print(i,":",e[i],"->", nnforward(wh,wo,h,e[i]))

# backp.pyの終わり
