﻿"""
knn.pyプログラム
k近傍法のプログラム
スマホとタブレットの分類
使い方　>python knn.py 
"""
# モジュールをインポート
import math

# 大域変数の定義
k = 3  # k近傍法における定数kの定義

# 下請け関数の定義
# knn()関数
def knn(width, length, ldata):
    # 各点との距離の計算
    res = [] # 距離の計算結果
    for p in ldata: # 学習データセットに対する距離の計算
        res.append([dist(p, width, length), p[2]])

    # 結果の集計
    res.sort(key = lambda x: x[0]) # 距離の小さい順に整列
    count = 0
    for i in range(k): # k番目まで調べる
        if res[i][1] == "s": # スマホなら
            count += 1       # countを1増やす
    if count >= k/2: # countの値がk/2より大きければスマホ
        return "スマホ"
    else: # 大きくなければタブレット
        return "タブレット"

# knn()関数の終わり

# dist()関数
def dist(p, width, length):
    # 距離の計算
    d = (width - p[0]) ** 2 + (length - p[1]) ** 2
    d = math.sqrt(d)
    return d
# dist()関数の終わり

# メイン実行部
# 学習データセットの設定
ldata = [[75, 160, "s"], [65, 135, "s"], [80, 170, "s"], [95, 155, "s"],
 [185, 240, "t"], [160, 220, "t"], [120, 160, "t"], [190, 260, "t"]]

# 問い合わせと分類結果の出力
while True :  #整数以外が入力されるまで繰り返す
    try:
        width = int(input("短辺を入力："))
        length = int(input("長辺を入力："))
    except :     #入力終了
        break
    print("分類結果", knn(width, length, ldata)) # knn()関数による分類

# knn.pyの終わり
